Texture g_Tex : register(t0);
sampler2D s = sampler_state {
	Texture = <g_Tex>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;
};

float4 Weights = {0.31, 0.61, 0.08, 0.0};

float4 Desaturate_Average ( float2 texCoords : TEXCOORD0 ) : COLOR
{
	float4 In = tex2D(s, texCoords);
	float Gray = dot(In, float4(0.333, 0.333, 0.333, 0.0));
	return float4(Gray, Gray, Gray, In.w);
}

float4 Desaturate_Weighted ( float2 texCoords : TEXCOORD0 ) : COLOR
{
	float4 In = tex2D(s, texCoords);
	float Gray = dot(In, Weights);
	return float4(Gray, Gray, Gray, In.w);
}

float4 Desaturate_Lightness ( float2 texCoords : TEXCOORD0 ) : COLOR
{
	float4 In = tex2D(s, texCoords);
	float Gray = 0.5 * (min(In.x, min(In.y, In.z)) + max(In.x, max(In.y, In.z)));
	return float4(Gray, Gray, Gray, In.w);
}

technique Average
{
	pass P0
	{
		PixelShader = compile ps_2_0 Desaturate_Average();
	}
}

technique Weighted
{
	pass p0
	{
		PixelShader = compile ps_2_0 Desaturate_Weighted();
	}
}

technique Lightness
{
	pass p0
	{
		PixelShader = compile ps_2_0 Desaturate_Lightness();
	}
}